<?php 
// Initialisation des compteurs pour les réponses de 1 à 9
$counts = array_fill(1, 9, 0);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Parcourir les réponses envoyées
    for ($i = 1; $i <= 180; $i++) {
        if (isset($_POST['A' . $i])) {
            $response = $_POST['A' . $i];
            if (isset($counts[$response])) {
                $counts[$response]++;
            }
        }
    }

    // Construire le contenu de l'email
    $message = "Résultats du questionnaire :\n";
    for ($i = 1; $i <= 9; $i++) {
        $message .= "Réponse $i : {$counts[$i]} fois\n";
    }

    // Envoyer les résultats par email
    send_results_via_email($message);
}

function send_results_via_email($message) {
    // Utiliser wp_mail pour envoyer l'email
    $to = 'prevost.pascal@gmail.com';
    $subject = 'Résultats du questionnaire NPM';
    //$headers = "From: wordpress@achacunsoncerveau.pro\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Utiliser la fonction mail de PHP
    //if (mail($to, $subject, $message, $headers)) {
    if (wp_mail($to, $subject, $message, $headers)) {    
        echo "<script>alert('Les résultats ont été envoyés avec succès.');</script>";
    } else {
        echo "<script>alert('L'envoi des résultats a échoué.');</script>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Questionnaire</title>
    <script type="text/javascript">
        function validForm() {
            var x = document.test.nom_prenom.value;
            if (x == null || x == "") {
                alert("Indiquez votre nom et votre prénom s'il vous plait");
                return false;
            }
            for (var i = 1; i <= 180; i++) {
                var radios = document.getElementsByName('A' + i);
                var isChecked = false;
                for (var j = 0; j < radios.length; j++) {
                    if (radios[j].checked) {
                        isChecked = true;
                        break;
                    }
                }
                if (!isChecked) {
                    alert("Case A" + i + " non cochée");
                    return false;
                }
            }
            return true;
        }
    </script>
</head>

<body>
    <div style="max-width:1000px;overflow:auto;margin-top: 20px;margin-left:auto;margin-right:auto;text-align:center;color:#282828;background:#fafafa;border-radius: 20px; padding: 10px;">
        <div width='600px'  align='left' style='font-size: 12px; font-family: Verdana, Helvetica, Arial, sans-serif;'> 
            <h2 style='font-size: 150%; font-weight: bold; color:#ff6600; font-family: Helvetica, Verdana, Arial, sans-serif;'>Bienvenue sur la page du profil neuroscientifique des motivations ou NPM<sup>&copy;</sup></h2>
            <p>Le test est conçu pour vous aider à déterminer quelle est la source de vos motivations. Le résultat permet également de mieux se connaitre, mieux comprendre les autres, développer ses talents,...</p>
            <p>Le questionnaire comporte 180 affirmations notifiées de A1 à A180. Pour chaque affirmation, vous avez deux possibilités pour répondre. L'objectif est de choisir l'affirmation qui vous convient le mieux de façon la plus objective possible… donc :
            <ul><li> entre deux affirmations qui vous correspondent toutes les deux, choisir la plus proche ;</li>
            <li> entre deux affirmations qui ne vous correspondent pas, choisir la moins pire.</li></ul>
            </p>
            <p>Lorsque vous choisissez une affirmation, il vous est demandé de prendre la réponse en rapport avec ce que vous <strong>ÊTES</strong> et non que celle en rapport avec ce que souhaiteriez être… ce qui n'est pas la même chose !</p> 
            <p>Le test dure entre 15 et 45 minutes si vous le faites en une seule fois. Vous pouvez vous arrêter et le reprendre plus tard (attention à ne pas fermer votre navigateur, sinon vous devrez tout reprendre depuis le début). Vous pouvez passer sur certaines questions et y revenir pour y répondre ou pour être sûr que la réponse correspond bien à ce que vous êtes.</p>
            <p>Il est indispensable de prendre une décision sincère, honnête et juste après avoir lu les deux affirmations.</p>
            <p>Le résultat ne sera pas valide ni pertinent si vous essayez de comprendre là où nous voulons en venir.</p>
            <p>Des tests croisés lors de l'analyse sont réalisés pour vérifier si vous n'avez pas triché.</p>
            <p>Il est nécessaire d'<strong>éviter toutes situations stressantes ou toutes émotions fortes avant de commencer le test</strong>.</p>
            <p>Vous pouvez utiliser la souris pour cliquer directement sur le symbole rond (bouton radio) permettant de valider votre choix. Vous pouvez également utiliser la touche de TABULATION pour passer d'une item à l'autre et utiliser la flèche haut-bas pour faire votre choix. Dans le cas où un item n'aurait pas été validé, une petite fenêtre souvrira au moment de valider pour vous indiquer lequel est à compléter.</p>
            <p>Bon courage !</p>
            <p>&nbsp</p>
            <p>&nbsp</p>
        </div>

                <form style="margin-top: 20px;" name="test" method="post" action="" onsubmit="return validForm()">
            <label for="nom_prenom">Nom et Prénom:</label>
            <input type="text" id="nom_prenom" name="nom_prenom"><br><br>


            <?php
            for($i=1;$i<181;$i++){
            	switch($i){
            		case 1:
            				$questiona="Pour moi, il est très important de prendre soin des autres.";
            				$questionb="Organiser les choses et les mener à terme me vient tout naturellement.";
            				$repA=2;
            				$repB=3;
            				break;
            		case 2:
            				$questiona="Pour moi, il est très important de bien me préparer avant de prendre une décision.";
            				$questionb="Pour moi, la vie est faite d'une grande variété d'expériences passionnantes.";
            				$repA=6;
            				$repB=7;
            				break;
            		case 3:
            				$questiona="Je me considère comme un observateur avisé.";
            				$questionb="J'ai toujours l'air de quelqu'un qui cherche constamment à s'améliorer.";
            				$repA=5;
            				$repB=1;
            				break;
            		case 4:
            				$questiona="Les autres me décrivent comme un \"réalisateur-compétiteur\".";
            				$questionb="Mes amis disent de moi que je suis une personne qui prend part aux souffrances des autres.";
            				$repA=3;
            				$repB=4;
            				break;
            		case 5:
            				$questiona="J'essaie toujours d'être attentif aux besoins des autres.";
            				$questionb="J'ai souvent tendance à dire autour de moi : \"Pourquoi s'agiter comme ça ? Pourquoi se faire du souci pour pas grand-chose ?\"";
            				$repA=2;
            				$repB=9;
            				break;
            		case 6:
            				$questiona="J'ai tendance à m'isoler rapidement si je ne me sens pas partie prenante de ce qui se passe.";
            				$questionb="Dans un groupe, je suis habituellement celui qui voit la vie du bon côté.";
            				$repA=5;
            				$repB=7;
            				break;
            		case 7:
            				$questiona="A travers mon éducation, j'ai pris l'habitude de compter sur ceux qui représentent l'autorité pour décider de mes comportements.";
            				$questionb="Face à la vie, je me considère comme un lutteur qui ne se laisse pas abattre.";
            				$repA=6;
            				$repB=8;
            				break;
            		case 8:
            				$questiona="Je souhaite souvent que les gens me comprennent mieux.";
            				$questionb="Je me considère comme peu exigeant et facile à vivre.";
            				$repA=4;
            				$repB=9;
            				break;
            		case 9:
            				$questiona="Mon \"apparence\" est très importante pour moi.";
            				$questionb="Je semble toujours prompt à réagir face aux périls de la vie.";
            				$repA=3;
            				$repB=6;
            				break;
            		case 10:
            				$questiona="Je me sens heureux lorsque j'essaie d'aider les autres.";
            				$questionb="J'aimerais être plus dynamique dans la vie, mais pour cela j'ai souvent besoin d'être stimulé de l'extérieur.";
            				$repA=2;
            				$repB=9;
            				break;
            		case 11:
            				$questiona="Je passe beaucoup de temps à cogiter, pour mieux donner sens à ma vie.";
            				$questionb="Si quelque chose a besoin d'être réparé, vous pouvez compter sur moi.";
            				$repA=5;
            				$repB=8;
            				break;
            		case 12:
            				$questiona="J'aime que mes relations aux autres soient exemptes de tensions.";
            				$questionb="Pour moi, il est important de m'efforcer à donner le meilleur de moi-même dans tout ce que je fais.";
            				$repA=9;
            				$repB=1;
            				break;
            		case 13:
            				$questiona="J'ai tendance à intérioriser chaque chose et à la conserver en moi.";
            				$questionb="Pour ma propre sécurité, j'ai un grand besoin de savoir ce qui est juste ou faux.";
            				$repA=5;
            				$repB=6;
            				break;
            		case 14:
            				$questiona="Je prends plaisir à me sentir proche des autres.";
            				$questionb="Dans une discussion, j'aime peser le pour et le contre.";
            				$repA=2;
            				$repB=9;
            				break;
            		case 15:
            				$questiona="Je mets toute mon énergie pour réussir dans le rôle qui est le mien.";
            				$questionb="Je semble avoir du courage en abondance.";
            				$repA=3;
            				$repB=8;
            				break;
            		case 16:
            				$questiona="Je prends plaisir à la vie plus que la plupart des gens.";
            				$questionb="J'ai l'impression que je travaille dur pour progresser.";
            				$repA=7;
            				$repB=1;
            				break;
            		case 17:
            				$questiona="Je me considère comme une personne très compétente.";
            				$questionb="Je suis en général habité par l'idée que les choses ne sont pas aussi parfaites qu'elles pourraient l'être.";
            				$repA=3;
            				$repB=1;
            				break;
            		case 18:
            				$questiona="Quand je fais partie d'un groupe, j'ai tendance à y assumer des responsabilités.";
            				$questionb="Dans une discussion, je prends toujours en compte les deux points de vue.";
            				$repA=6;
            				$repB=9;
            				break;
            		case 19:
            				$questiona="Les autres ne s'imaginent pas à quel point je ressens profondément les choses.";
            				$questionb="J'aime aborder la vie de manière simple et directe.";
            				$repA=4;
            				$repB=8;
            				break;
            		case 20:
            				$questiona="Je me considère comme quelqu'un de très prudent.";
            				$questionb="C'est pour moi très important d'avoir raison.";
            				$repA=6;
            				$repB=1;
            				break;
            		case 21:
            				$questiona="Je me considère comme quelqu'un de très efficace.";
            				$questionb="Je ressens souvent le désir de m'engager plus fortement dans la vie, mais je ne sais pas comment y arriver.";
            				$repA=3;
            				$repB=5;
            				break;
            		case 22:
            				$questiona="J'éprouve une satisfaction personnelle lorsque je vis des sentiments très intenses.";
            				$questionb="Je mets beaucoup d'enthousiasme dans la plupart des situations.";
            				$repA=4;
            				$repB=7;
            				break;
            		case 23:
            				$questiona="Je suis un bon observateur.";
            				$questionb="Je suis quelqu'un de très optimiste.";
            				$repA=5;
            				$repB=7;
            				break;
            		case 24:
            				$questiona="Je veux être important dans la vie des autres.";
            				$questionb="J'ai tendance à travailler très dur pour que les choses soit parfaites.";
            				$repA=2;
            				$repB=1;
            				break;
            		case 25:
            				$questiona="J'ai plaisir à donner de moi une image enthousiaste et énergique.";
            				$questionb="Face à une situation d'injustice, je ne peux m'empêcher de me battre pour y remédier.";
            				$repA=3;
            				$repB=8;
            				break;
            		case 26:
            				$questiona="Je suis constamment en train de collecter et emmagasiner des informations et connaissances.";
            				$questionb="C'est pour moi important de me sentir détendu dans n'importe quelle situation.";
            				$repA=5;
            				$repB=9;
            				break;
            		case 27:
            				$questiona="Je pense que j'écoute les autres avec mon cœur.";
            				$questionb="Souvent je pense que les autres ne ressentent pas les choses aussi profondément que moi.";
            				$repA=2;
            				$repB=4;
            				break;
            		case 28:
            				$questiona="Je passe beaucoup de temps à me comparer aux autres.";
            				$questionb="Mes amis disent que l'on peut compter sur moi.";
            				$repA=4;
            				$repB=1;
            				break;
            		case 29:
            				$questiona="La vie et ses exigences ont fait de moi quelqu'un de très sérieux.";
            				$questionb="Je fais souvent de nouveaux projets avant même d'avoir terminé ceux que j'ai commencés.";
            				$repA=6;
            				$repB=7;
            				break;
            		case 30:
            				$questiona="Je me considère comme une personne très aimante.";
            				$questionb="Je pense que la vie doit être gaie, et j'ai bien l'intention d'y trouver de la joie.";
            				$repA=2;
            				$repB=7;
            				break;
            		case 31:
            				$questiona="J'ai un grand pouvoir de persuasion pour influencer les autres.";
            				$questionb="Je suis presque toujours calme et paisible face aux angoisses de la vie.";
            				$repA=3;
            				$repB=9;
            				break;
            		case 32:
            				$questiona="J'ai tendance à beaucoup observer ce qui se passe autour de moi plutôt que de m'y impliquer.";
            				$questionb="Je suis heureux lorsque je me sens en sécurité et à l'abri de tout danger.";
            				$repA=5;
            				$repB=6;
            				break;
            		case 33:
            				$questiona="Je m'enthousiasme facilement pour beaucoup de choses, mais alors j'ai tendance à me disperser.";
            				$questionb="Je détecte rapidement la faille chez les autres ou dans une situation donnée.";
            				$repA=7;
            				$repB=8;
            				break;
            		case 34:
            				$questiona="J'ai une réelle compassion pour les autres.";
            				$questionb="Je suis heureux d'appartenir à un groupe qui fait appel à mon dévouement.";
            				$repA=2;
            				$repB=6;
            				break;
            		case 35:
            				$questiona="J'ai un très grand besoin de faire des choses pour me réaliser et de sentir que je suis une personne accomplie.";
            				$questionb="Dans une situation de conflit, j'essaie toujours de calmer les esprits.";
            				$repA=3;
            				$repB=9;
            				break;
            		case 36:
            				$questiona="Je me considère comme quelqu'un de très sensible.";
            				$questionb="Je suis habituellement optimiste face à la plupart des choses, et je laisse tomber ce qui est pénible.";
            				$repA=4;
            				$repB=7;
            				break;
            		case 37:
            				$questiona="Je crois à l'impact d'un engagement sincère dans un groupe qui a un objectif commun.";
            				$questionb="Je ne mets pas beaucoup d'énergie à être conforme aux normes.";
            				$repA=6;
            				$repB=9;
            				break;
            		case 38:
            				$questiona="J'aime rendre service aux autres.";
            				$questionb="La capacité à organiser les choses me vient tout naturellement.";
            				$repA=2;
            				$repB=3;
            				break;
            		case 39:
            				$questiona="Je suis une personne très compatissante.";
            				$questionb="Je pense que mes amis me considèrent comme quelqu'un de très optimiste.";
            				$repA=4;
            				$repB=7;
            				break;
            		case 40:
            				$questiona="Je suis très attentif à l'image que je donne de moi.";
            				$questionb="Je suis toujours prêt à défendre les gens en toute circonstance.";
            				$repA=3;
            				$repB=8;
            				break;
            		case 41:
            				$questiona="Je suis peu enclin à montrer mes sentiments aux autres.";
            				$questionb="J'ai beaucoup de mal à occuper mes temps de loisirs.";
            				$repA=5;
            				$repB=6;
            				break;
            		case 42:
            				$questiona="Je suis une personne très sensible et qui prend part aux souffrances des autres.";
            				$questionb="J'éprouve le besoin de tendre vers la perfection dans tout ce que je fais.";
            				$repA=4;
            				$repB=1;
            				break;
            		case 43:
            				$questiona="Je suis une personne très sûre d'elle-même.";
            				$questionb="Je crois que le succès d'un groupe exige de chaque individu qu'il renonce à ses propres besoins et à ses intérêts égoïstes.";
            				$repA=3;
            				$repB=6;
            				break;
            		case 44:
            				$questiona="La routine me satisfait dans la mesure où elle signifie généralement une absence de problèmes.";
            				$questionb="Je suis une personne sur qui l'on peut compter.";
            				$repA=9;
            				$repB=1;
            				break;
            		case 45:
            				$questiona="Je pense que j'élève chez les autres la conscience de ce qui est beau.";
            				$questionb="Quand une personne me demande comment je me sens, plutôt que de partager mes sentiments, je ne lui dis pas ce que je pense.";
            				$repA=4;
            				$repB=5;
            				break;
            		case 46:
            				$questiona="Pour moi, il est important de réaliser des choses et d'être reconnu pour mes efforts.";
            				$questionb="Je tends toujours vers la perfection dans tout ce que je fais.";
            				$repA=3;
            				$repB=1;
            				break;
            		case 47:
            				$questiona="Je crois être quelqu'un qui cherche à acquérir toujours plus de sagesse et de clairvoyance.";
            				$questionb="Je crois être une personne très dévouée.";
            				$repA=5;
            				$repB=6;
            				break;
            		case 48:
            				$questiona="J'aime aller au secours des gens qui se trouvent dans des situations de détresse.";
            				$questionb="Je suis toujours prêt à passer plus de temps sur une tâche pour qu'elle soit bien faite.";
            				$repA=2;
            				$repB=1;
            				break;
            		case 49:
            				$questiona="Je m'investis totalement pour atteindre mes objectifs.";
            				$questionb="Dans un conflit, je cherche à convaincre en avançant des arguments.";
            				$repA=3;
            				$repB=9;
            				break;
            		case 50:
            				$questiona="Je passe beaucoup de temps à chercher des explications sur ce qui se passe autour de moi.";
            				$questionb="Je considère que la vie en groupe est très importante et je suis prêt à y mettre le prix.";
            				$repA=4;
            				$repB=6;
            				break;
            		case 51:
            				$questiona="Je suis une personne qui encourage facilement les autres et qui leur fait régulièrement des compliments.";
            				$questionb="Je suis curieux de tout ce qui se passe autour de moi, sans vraiment m'impliquer.";
            				$repA=2;
            				$repB=5;
            				break;
            		case 52:
            				$questiona="Je préfère donner des ordres plutôt que de les recevoir.";
            				$questionb="Je cherche toujours l'harmonie avec ceux qui m'entourent.";
            				$repA=8;
            				$repB=9;
            				break;
            		case 53:
            				$questiona="J'accepte difficilement l'inefficacité et l'apparente perte de temps dans la manière de travailler des autres.";
            				$questionb="Il semble toujours y avoir quelque chose à craindre de la vie.";
            				$repA=3;
            				$repB=6;
            				break;
            		case 54:
            				$questiona="J'ai souvent du mal à exprimer ce que je ressens réellement et à demander ce que je veux.";
            				$questionb="Je me vois souvent en train de critiquer en disant comment les choses devraient être.";
            				$repA=5;
            				$repB=1;
            				break;
            		case 55:
            				$questiona="Mon \"apparence\" est très importante pour moi.";
            				$questionb="Je semble toujours prêt à réagir face aux périls de la vie.";
            				$repA=3;
            				$repB=6;
            				break;
            		case 56:
            				$questiona="J'attends généralement des autres qu'ils soient disposés à faire des sacrifices personnels pour réussir.";
            				$questionb="Je crois être quelqu'un de très efficace.";
            				$repA=3;
            				$repB=1;
            				break;
            		case 57:
            				$questiona="Je répète volontiers ce que j'ai bien fait dans le passé.";
            				$questionb="Je veux être au-dessus de toute critique ou condamnation venant de qui que ce soit.";
            				$repA=6;
            				$repB=1;
            				break;
            		case 58:
            				$questiona="Je ressens le besoin permanent d'aider les autres.";
            				$questionb="Je ressens un profond besoin de redresser les torts et les injustices de la vie.";
            				$repA=2;
            				$repB=8;
            				break;
            		case 59:
            				$questiona="Pour agir, j'ai besoin de directives claires et appropriées.";
            				$questionb="On pourrait me décrire comme un \"hyper-idéaliste\".";
            				$repA=6;
            				$repB=7;
            				break;
            		case 60:
            				$questiona="Je passe beaucoup de temps à réfléchir.";
            				$questionb="Je suis habituellement celui qui essaie de faire la paix dans une dispute.";
            				$repA=5;
            				$repB=9;
            				break;
            		case 61:
            				$questiona="Je veux que les gens que je rencontre se sentent importants et aimés.";
            				$questionb="Je pense souvent que je ressens émotionnellement les choses plus profondément que les autres.";
            				$repA=2;
            				$repB=4;
            				break;
            		case 62:
            				$questiona="Pour moi, la vie représente une multitude d'opportunités.";
            				$questionb="Je suis très direct dans mes relations aux autres.";
            				$repA=7;
            				$repB=8;
            				break;
            		case 63:
            				$questiona="J'accorde beaucoup de prix à ce qui est beau.";
            				$questionb="Je prends souvent du recul vis à vis des autres pour réfléchir ou reconstruire la réalité dans une perspective qui a du sens.";
            				$repA=4;
            				$repB=5;
            				break;
            		case 64:
            				$questiona="Mes amis disent de moi que j'ai beaucoup de courage.";
            				$questionb="J'ai des idées très affirmées sur la façon dont les choses devraient être.";
            				$repA=8;
            				$repB=1;
            				break;
            		case 65:
            				$questiona="Il m'est facile d'être attentionné et de me soucier des autres.";
            				$questionb="Avec l'innocence de l'enfant, j'ai tendance à voir le bien en chacun et en toute chose.";
            				$repA=2;
            				$repB=7;
            				break;
            		case 66:
            				$questiona="Je suis très attentif aux autres et je veux qu'ils se sentent importants.";
            				$questionb="Je partage souvent les sentiments profonds et les souffrances des autres.";
            				$repA=2;
            				$repB=4;
            				break;
            		case 67:
            				$questiona="Je prends plaisir à la vie plus que la plupart des gens.";
            				$questionb="Je ressens le besoin profond et irrésistible de m'améliorer.";
            				$repA=7;
            				$repB=1;
            				break;
            		case 68:
            				$questiona="J'aime m'identifier à mon entourage et je rêve souvent aux rôles à succès que je pourrais jouer.";
            				$questionb="Je dépense beaucoup d'énergie à savoir ce qui se passe autour de moi sans jamais vraiment m'impliquer.";
            				$repA=3;
            				$repB=5;
            				break;
            		case 69:
            				$questiona="J'attache une grande importance au \"sens de la vie\" et à son côté tragique.";
            				$questionb="Je suis plus à l'aise quand j'ai un rôle de second plan.";
            				$repA=4;
            				$repB=6;
            				break;
            		case 70:
            				$questiona="Je fais toujours le maximum pour éviter l'échec.";
            				$questionb="Je suis d'un naturel \"euphorique\".";
            				$repA=3;
            				$repB=7;
            				break;
            		case 71:
            				$questiona="Je crois être une personne généreuse dans un monde nécessiteux.";
            				$questionb="Je prends souvent du recul par rapport à mon entourage pour analyser plus profondément les événements.";
            				$repA=2;
            				$repB=4;
            				break;
            		case 72:
            				$questiona="J'ai tendance à redouter l'avenir.";
            				$questionb="Être stimulé, c'est un problème pour moi : quand et comment vais-je trouver en moi ma propre énergie ?";
            				$repA=6;
            				$repB=9;
            				break;
            		case 73:
            				$questiona="Je pense que je prends en compte les besoins des autres avant les miens.";
            				$questionb="Mes amis disent que j'ai des difficultés à être en contact avec mes sentiments.";
            				$repA=2;
            				$repB=5;
            				break;
            		case 74:
            				$questiona="Je connais la souffrance et ce que c'est que d'être incompris.";
            				$questionb="J'ai de l'estime pour les leaders comme moi qui s'engagent à prendre soin des gens qui font le sale boulot.";
            				$repA=4;
            				$repB=6;
            				break;
            		case 75:
            				$questiona="Dans une situation difficile, je manque rarement de confiance en moi.";
            				$questionb="Je considère la perfection comme accessible et je suis prêt à travailler dur pour y arriver.";
            				$repA=8;
            				$repB=1;
            				break;
            		case 76:
            				$questiona="Pour moi, il est très important de consacrer du temps à développer mes relations avec les personnes.";
            				$questionb="Je suis très habile à me protéger des émotions fortes : elles sont une menace pour moi.";
            				$repA=2;
            				$repB=5;
            				break;
            		case 77:
            				$questiona="Je veux réaliser quelque chose d'authentique et d'unique dans la vie.";
            				$questionb="Je pressens le danger et les menaces plus que les autres.";
            				$repA=4;
            				$repB=6;
            				break;
            		case 78:
            				$questiona="Je suis souvent envahi par des sentiments de tristesse.";
            				$questionb="Mes amis me considèrent comme quelqu'un sur qui on peut compter dans une situation difficile.";
            				$repA=4;
            				$repB=8;
            				break;
            		case 79:
            				$questiona="Je considère la vie d'un groupe comme très importante et je suis prêt à y mettre le prix.";
            				$questionb="J'éprouve en permanence le besoin de tout améliorer.";
            				$repA=6;
            				$repB=1;
            				break;
            		case 80:
            				$questiona="Je suis capable de transformer des échecs présumés en succès.";
            				$questionb="Attendez toujours de moi le bon goût et les bonnes manières.";
            				$repA=3;
            				$repB=4;
            				break;
            		case 81:
            				$questiona="J'aime les défis et je suis à l'aise dans les situations difficiles.";
            				$questionb="J'ai les idées très affirmées sur la façon dont les choses devraient être.";
            				$repA=8;
            				$repB=1;
            				break;
            		case 82:
            				$questiona="J'accorde une très grande valeur aux relations avec les personnes.";
            				$questionb="Je suis très prudent en tout ce que j'entreprends dans le cadre de mes responsabilités.";
            				$repA=2;
            				$repB=6;
            				break;
            		case 83:
            				$questiona="Je me considère comme une personne sûre d'elle-même et pleine d'assurance.";
            				$questionb="Je veux que ma vie soit une vie d'ordre et de stabilité.";
            				$repA=8;
            				$repB=9;
            				break;
            		case 84:
            				$questiona="Le souci de l'avenir et le courage de l'affronter sont importants pour moi.";
            				$questionb="Ma présence peut par elle-même apaiser les gens : ce qui est nécessaire à beaucoup.";
            				$repA=6;
            				$repB=9;
            				break;
            		case 85:
            				$questiona="Je suis capable de prédire mes succès bien avant qu'ils ne se réalisent.";
            				$questionb="J'ai souvent tendance à planifier plus de choses que je n'ai le temps d'en faire.";
            				$repA=3;
            				$repB=7;
            				break;
            		case 86:
            				$questiona="Je pense avoir le don d'être quelqu'un d'unique et d'original.";
            				$questionb="J'ai tendance à étudier tous les détails avant de prendre une décision.";
            				$repA=4;
            				$repB=1;
            				break;
            		case 87:
            				$questiona="Je suis très sensible à l'ambiance émotionnelle d'un groupe.";
            				$questionb="Mon comportement non-menaçant aide les autres à se poser et à devenir plus paisibles.";
            				$repA=4;
            				$repB=9;
            				break;
            		case 88:
            				$questiona="J'aimerais être plus sociable, quelque chose en moi m'en empêche.";
            				$questionb="Je regarde habituellement le bon côté des choses.";
            				$repA=5;
            				$repB=7;
            				break;
            		case 89:
            				$questiona="Je suis convaincu de réaliser de grandes choses dans ma vie.";
            				$questionb="J'ai en général tendance à éviter les conflits.";
            				$repA=3;
            				$repB=9;
            				break;
            		case 90:
            				$questiona="Je cherche toujours à comprendre et à voir clair dans tout ce qui m'entoure.";
            				$questionb="J'aime connaître tous les détails avant de prendre une décision.";
            				$repA=5;
            				$repB=1;
            				break;
            		case 91:
            				$questiona="Je planifie et organise soigneusement ma vie et je choisis mes relations personnelles pour atteindre mes objectifs.";
            				$questionb="J'ai tendance à m'investir totalement dans ce qui m'intéresse.";
            				$repA=3;
            				$repB=7;
            				break;
            		case 92:
            				$questiona="J'ai souvent conscience que je devrais m'engager davantage.";
            				$questionb="Je suis une personne qui prend systématiquement les choses en mains.";
            				$repA=5;
            				$repB=8;
            				break;
            		case 93:
            				$questiona="J'attache une grande valeur à mes relations avec les autres.";
            				$questionb="J'ai tendance à calmer les situations tendues pour que les gens se sentent à l'aise.";
            				$repA=2;
            				$repB=9;
            				break;
            		case 94:
            				$questiona="Je me fixe facilement des objectifs personnels et je prends rapidement les décisions en vue de les réaliser.";
            				$questionb="Je crois qu'un peu d'humour peut mettre un peu de baume sur nombre de souffrances de la vie.";
            				$repA=3;
            				$repB=7;
            				break;
            		case 95:
            				$questiona="Tout au long de ma vie, j'ai eu beaucoup de mal à encaisser les humiliations, les dénigrements, et les critiques des autres.";
            				$questionb="Une place pour chaque chose et chaque chose à sa place.";
            				$repA=5;
            				$repB=1;
            				break;
            		case 96:
            				$questiona="Je prends du plaisir aux choses belles et authentiques.";
            				$questionb="Je me considère plus fort que la plupart des gens.";
            				$repA=4;
            				$repB=8;
            				break;
            		case 97:
            				$questiona="Mes amis me considèrent comme un travailleur infatigable.";
            				$questionb="Je travaille dur pour progresser dans les domaines qui me paraissent souhaitables.";
            				$repA=3;
            				$repB=1;
            				break;
            		case 98:
            				$questiona="Avant de prendre une décision, je me tourne souvent vers les autres pour me guider et m'aider à discerner.";
            				$questionb="Je me considère comme un leader naturel.";
            				$repA=6;
            				$repB=8;
            				break;
            		case 99:
            				$questiona="Je pense ressentir les choses plus profondément que la plupart des gens.";
            				$questionb="Je prends souvent du recul par rapport aux autres pour réfléchir.";
            				$repA=4;
            				$repB=5;
            				break;
            		case 100:
            				$questiona="J'ai tendance à anticiper ce qu'il y a de meilleur dans la vie.";
            				$questionb="Mes amis disent que je fais tout pour que la vie ne soit pas ennuyeuse.";
            				$repA=7;
            				$repB=8;
            				break;
            		case 101:
            				$questiona="J'aime faire en sorte que les autres se sentent importants et aimés.";
            				$questionb="J'ai une grande capacité à motiver les autres à travailler pour une chose qui en vaut vraiment la peine.";
            				$repA=2;
            				$repB=3;
            				break;
            		case 102:
            				$questiona="Je m'implique rarement dans quelque chose avant de l'avoir complètement analysé.";
            				$questionb="J'ai beaucoup en commun avec \"Peter Pan\" (qui vit comme un éternel enfant dans un royaume enchanté).";
            				$repA=4;
            				$repB=7;
            				break;
            		case 103:
            				$questiona="Je suis quelqu'un qui a beaucoup de compassion.";
            				$questionb="J'aime apprendre et je révèle rarement tout ce que je sais.";
            				$repA=2;
            				$repB=5;
            				break;
            		case 104:
            				$questiona="Je suis constamment en train de tirer des plans pour changer le monde.";
            				$questionb="Vous pouvez compter sur moi.";
            				$repA=7;
            				$repB=1;
            				break;
            		case 105:
            				$questiona="Je me considère comme une personne chaleureuse et soucieuse des autres.";
            				$questionb="Je monte facilement au créneau pour défendre mes convictions.";
            				$repA=2;
            				$repB=8;
            				break;
            		case 106:
            				$questiona="Je travaille dur pour réaliser les choses, car la pensée de l'échec m'est insupportable.";
            				$questionb="J'ai un grand souci d'authenticité et je passe beaucoup de temps à chercher qui je suis vraiment.";
            				$repA=3;
            				$repB=4;
            				break;
            		case 107:
            				$questiona="Je suis parfois \"hyper-enthousiaste\", aimant me faire remarquer.";
            				$questionb="Pour moi, il est important d'être quelqu'un sur qui on peut compter.";
            				$repA=7;
            				$repB=1;
            				break;
            		case 108:
            				$questiona="J'aime faire des compliments aux autres.";
            				$questionb="En toutes circonstances, je défends mes droits et ceux des autres.";
            				$repA=2;
            				$repB=8;
            				break;
            		case 109:
            				$questiona="J'aime me dévouer au groupe auquel j'appartiens, quel qu'il soit.";
            				$questionb="A partir du moment où je me mets quelque chose en tête, je pense pouvoir le réaliser.";
            				$repA=6;
            				$repB=8;
            				break;
            		case 110:
            				$questiona="Je prends l'échec comme une grande atteinte à ma personne.";
            				$questionb="Je me demande souvent si je suis assez courageux pour faire tout ce que j'ai à faire.";
            				$repA=3;
            				$repB=6;
            				break;
            		case 111:
            				$questiona="J'aime manifester de la compassion aux autres.";
            				$questionb="J'ai toujours un tas de rêves et de projets pour l'avenir.";
            				$repA=2;
            				$repB=7;
            				break;
            		case 112:
            				$questiona="Ma grande sensibilité fait que je ressens souvent des souffrances que les autres ne voient même pas.";
            				$questionb="Je suis un observateur très aigu de ce qui se passe autour de moi.";
            				$repA=4;
            				$repB=5;
            				break;
            		case 113:
            				$questiona="J'ai une grande capacité à me motiver.";
            				$questionb="J'aide souvent les autres à prendre du recul face à leurs problèmes.";
            				$repA=8;
            				$repB=9;
            				break;
            		case 114:
            				$questiona="Je me prépare bien avant de prendre une décision.";
            				$questionb="Je suis paisible dans un environnement calme et posé.";
            				$repA=6;
            				$repB=9;
            				break;
            		case 115:
            				$questiona="Je suis tellement sensible et différent que j'ai souvent l'impression de ne pas être à ma place.";
            				$questionb="J'essaie toujours de faire ce qui est juste et j'attends des autres qu'ils fassent de même.";
            				$repA=4;
            				$repB=1;
            				break;
            		case 116:
            				$questiona="Je pense avoir été élevé avec le message : \"Sois un gagneur\".";
            				$questionb="Ma confiance en moi peut encourager ceux qui ont moins de courage à exprimer leurs sentiments réels.";
            				$repA=3;
            				$repB=8;
            				break;
            		case 117:
            				$questiona="J'apprécie la grande variété d'expériences que la vie nous offre.";
            				$questionb="J'ai l'impression que je suis toujours en train de critiquer en disant comment les choses devraient être.";
            				$repA=7;
            				$repB=1;
            				break;
            		case 118:
            				$questiona="Je pense que j'écoute les autres avec mon cœur.";
            				$questionb="Je suis plus sensible aux souffrances de la vie que la plupart des gens.";
            				$repA=2;
            				$repB=4;
            				break;
            		case 119:
            				$questiona="Pour moi, il est important de voir clair dans la vie et d'avoir du courage.";
            				$questionb="Je ne suis pas du genre à cacher mon insatisfaction sur quoi que ce soit, et je l'exprime immédiatement au grand jour.";
            				$repA=6;
            				$repB=8;
            				break;
            		case 120:
            				$questiona="C'est pour moi très important d'obtenir l'approbation des autres.";
            				$questionb="Je semble toujours penser que les choses ne sont jamais assez bonnes.";
            				$repA=2;
            				$repB=1;
            				break;
            		case 121:
            				$questiona="J'ai parfois des difficultés à m'engager, tellement j'ai de projets dans la tête.";
            				$questionb="Je suis du genre à insister pour que tout le monde puisse s'arrêter et débattre de ses différences.";
            				$repA=7;
            				$repB=9;
            				break;
            		case 122:
            				$questiona="Je suis souvent contrarié lorsque les autres empiètent sur mon temps.";
            				$questionb="Je pars en croisade pour ce que je considère juste et contre ce que je considère faux.";
            				$repA=5;
            				$repB=8;
            				break;
            		case 123:
            				$questiona="Mes amis savent qu'ils peuvent compter sur moi pour les aider quand ils en ont besoin.";
            				$questionb="J'ai besoin d'être confirmé et approuvé par ceux qui détiennent l'autorité.";
            				$repA=2;
            				$repB=6;
            				break;
            		case 124:
            				$questiona="J'ai tendance à beaucoup protéger mon intimité.";
            				$questionb="J'ai une grande capacité à trouver beaucoup de joie dans la vie.";
            				$repA=5;
            				$repB=7;
            				break;
            		case 125:
            				$questiona="Le travail et le succès qui en résultent constituent une part essentielle de ma vie.";
            				$questionb="Je ne suis pas du genre à parler de banalités dans les rencontres mondaines.";
            				$repA=3;
            				$repB=5;
            				break;
            		case 126:
            				$questiona="J'ai tendance à tirer les choses au clair pour moi d'abord, et ensuite seulement communiquer mes conclusions aux autres.";
            				$questionb="Je crois profondément au \"fair-play\".";
            				$repA=5;
            				$repB=8;
            				break;
            		case 127:
            				$questiona="Je prends un immense plaisir à tout ce qui touche à la nature et à la vie.";
            				$questionb="Je donne rarement des conseils aux autres, mais j'essaie de les aider à prendre du recul par rapport à leurs problèmes.";
            				$repA=7;
            				$repB=9;
            				break;
            		case 128:
            				$questiona="J'aime donner toutes ses chances à ma relation avec les autres.";
            				$questionb="Je suis sensible à l'injustice, qu'elle soit dirigée contre moi ou contre les autres.";
            				$repA=7;
            				$repB=8;
            				break;
            		case 129:
            				$questiona="Je préfère passer mon temps à des projets intellectuels plutôt qu'à ruminer mes sentiments.";
            				$questionb="J'ai un problème d'inertie : si je suis occupé je ne peux pas m'arrêter; si je suis oisif je ne peux pas commencer.";
            				$repA=5;
            				$repB=9;
            				break;
            		case 130:
            				$questiona="J'aime beaucoup me soucier des besoins des autres.";
            				$questionb="Je reçois la plupart des choses comme des dons et je savoure pleinement la vie.";
            				$repA=2;
            				$repB=7;
            				break;
            		case 131:
            				$questiona="Je me réjouis du retour positif que j'obtiens en convainquant et en influençant les autres.";
            				$questionb="Je semble toujours être contraint à m'améliorer.";
            				$repA=3;
            				$repB=1;
            				break;
            		case 132:
            				$questiona="Je prends plaisir au côté artistique de la vie.";
            				$questionb="J'observe très attentivement ce qui se passe autour de moi.";
            				$repA=4;
            				$repB=5;
            				break;
            		case 133:
            				$questiona="Toucher et étreindre font partie de mon style de communication avec les autres.";
            				$questionb="Je pense que ma volonté de réussir rassure beaucoup ceux qui m'entourent.";
            				$repA=2;
            				$repB=3;
            				break;
            		case 134:
            				$questiona="J'aime les situations sans conflits.";
            				$questionb="Je trouve que je peux mieux faire.";
            				$repA=9;
            				$repB=1;
            				break;
            		case 135:
            				$questiona="J'ai besoin d'être reconnu pour ce que j'ai fait.";
            				$questionb="Je suis un observateur avisé qui perçoit bien les choses.";
            				$repA=3;
            				$repB=5;
            				break;
            		case 136:
            				$questiona="Je me considère comme peu exigeant et facile à vivre.";
            				$questionb="Vous pouvez compter sur moi pour bien faire les choses.";
            				$repA=9;
            				$repB=1;
            				break;
            		case 137:
            				$questiona="Mes amis me considèrent comme quelqu'un de très sensible.";
            				$questionb="J'ai un réel désir d'améliorer la situation de ceux qui ont besoin d'aide.";
            				$repA=4;
            				$repB=8;
            				break;
            		case 138:
            				$questiona="J'ai un profond désir de m'occuper des autres.";
            				$questionb="J'accorde beaucoup d'importance aux détails qui mènent à une décision.";
            				$repA=2;
            				$repB=1;
            				break;
            		case 139:
            				$questiona="C'est important pour moi d'être considéré comme quelqu'un d'unique et de spécial.";
            				$questionb="Ma capacité à écouter les problèmes des autres peut apporter le calme dans une situation instable.";
            				$repA=4;
            				$repB=9;
            				break;
            		case 140:
            				$questiona="Je suis quelqu'un de loyal et qui a le sens du devoir.";
            				$questionb="Je pense avoir un bon jugement sur la façon dont les choses devraient être.";
            				$repA=6;
            				$repB=1;
            				break;
            		case 141:
            				$questiona="Je vis souvent des sentiments de tristesse et de résignation.";
            				$questionb="Je donne beaucoup d'importance à la paix et à l'harmonie.";
            				$repA=4;
            				$repB=9;
            				break;
            		case 142:
            				$questiona="Vous pouvez attendre de moi d'en faire encore plus pour éviter l'échec.";
            				$questionb="J'espère comprendre un jour mes sentiments profonds et mes émotions.";
            				$repA=3;
            				$repB=4;
            				break;
            		case 143:
            				$questiona="Ma philosophie est : \"Plus la vie est dure, plus je réagis avec force et ténacité\".";
            				$questionb="Je travaille très dur pour être au dessus de toute critique.";
            				$repA=8;
            				$repB=1;
            				break;
            		case 144:
            				$questiona="Une bonne partie de mon temps se passe à me préparer.";
            				$questionb="Je peux difficilement me passer de ce qui me procure du plaisir.";
            				$repA=6;
            				$repB=7;
            				break;
            		case 145:
            				$questiona="Je veux être important dans la vie des autres.";
            				$questionb="Pour moi, il est très important d'avoir raison.";
            				$repA=2;
            				$repB=1;
            				break;
            		case 146:
            				$questiona="Me soucier des autres est très important pour moi.";
            				$questionb="Il me semble tout naturel d'organiser les choses et les mener à terme.";
            				$repA=2;
            				$repB=3;
            				break;
            		case 147:
            				$questiona="Je considère la plupart des choses comme très intéressantes à connaître.";
            				$questionb="Mes amis me voient comme une personne calme et rassurante.";
            				$repA=5;
            				$repB=9;
            				break;
            		case 148:
            				$questiona="Pour atteindre mes buts dans la vie, je me donne des objectifs clairs auxquels je m'identifie fortement.";
            				$questionb="Mes amis disent que je suis quelqu'un de très compatissant.";
            				$repA=3;
            				$repB=4;
            				break;
            		case 149:
            				$questiona="J'arrive à trouver du plaisir dans beaucoup de choses.";
            				$questionb="J'échappe à l'angoisse en évacuant les sentiments et les émotions qui m'affectent.";
            				$repA=7;
            				$repB=9;
            				break;
            		case 150:
            				$questiona="Je passe beaucoup de temps à me comparer aux autres.";
            				$questionb="Vous pouvez avoir une grande confiance en moi.";
            				$repA=4;
            				$repB=1;
            				break;
            		case 151:
            				$questiona="Je suis capable d'apporter la bonne humeur quelle que soit la situation. Je suis un optimiste.";
            				$questionb="Je suis très soucieux de la paix et de l'harmonie dans mes relations aux autres.";
            				$repA=7;
            				$repB=9;
            				break;
            		case 152:
            				$questiona="Je me considère comme quelqu'un de très efficace.";
            				$questionb="Je ressens souvent un profond désir d'être plus actif et je ne sais pas comment faire.";
            				$repA=3;
            				$repB=5;
            				break;
            		case 153:
            				$questiona="Dans une situation difficile, je préfère éviter de me montrer faible ou dépendant des autres.";
            				$questionb="J'assume souvent une situation tendue ou perturbée en restant imperturbable et immuable.";
            				$repA=8;
            				$repB=9;
            				break;
            		case 154:
            				$questiona="J'ai souvent des difficultés à exprimer ce que je ressens réellement et à demander ce que je veux.";
            				$questionb="Pour moi, il est très important de bien faire les choses.";
            				$repA=5;
            				$repB=1;
            				break;
            		case 155:
            				$questiona="C'est très important pour moi que chaque chose soit bien comprise.";
            				$questionb="Attendez-vous à ce que je sois totalement dévoué et loyal envers le groupe auquel j'appartiens";
            				$repA=5;
            				$repB=6;
            				break;
            		case 156:
            				$questiona="Je suis quelqu'un qui essaie de comprendre les autres.";
            				$questionb="J'attends beaucoup des autres qu'ils fassent bien les choses.";
            				$repA=9;
            				$repB=1;
            				break;
            		case 157:
            				$questiona="L'amour est la principale source de bonheur dans la vie.";
            				$questionb="J'ai confiance dans ma capacité à faire mon chemin dans ce monde.";
            				$repA=2;
            				$repB=8;
            				break;
            		case 158:
            				$questiona="J'irai jusqu'au bout de mes efforts pour ne pas échouer.";
            				$questionb="Je suis presque toujours d'une humeur optimiste et joyeuse.";
            				$repA=3;
            				$repB=7;
            				break;
            		case 159:
            				$questiona="Je suis très attiré par ce qui est beau dans la vie.";
            				$questionb="Pour moi il est important de me sentir en sécurité.";
            				$repA=4;
            				$repB=6;
            				break;
            		case 160:
            				$questiona="Je préfère éviter les situations ambiguës et les grands changements.";
            				$questionb="Face à la vie, vous pouvez me considérer comme un lutteur qui ne se laisse pas abattre.";
            				$repA=6;
            				$repB=8;
            				break;
            		case 161:
            				$questiona="J'ai une authentique compassion pour les autres.";
            				$questionb="Je fonctionne mieux avec des directives appropriées et clairement définies.";
            				$repA=2;
            				$repB=6;
            				break;
            		case 162:
            				$questiona="Je donne l'impression d'être à la recherche de \"qui je suis\".";
            				$questionb="Je pense donner l'image de quelqu'un sur qui on peut compter.";
            				$repA=4;
            				$repB=8;
            				break;
            		case 163:
            				$questiona="Il m'est facile de donner mon attention et d'être soucieux des autres.";
            				$questionb="Je suis souvent conscient d'être au centre de l'attention des autres, du regard des autres.";
            				$repA=2;
            				$repB=5;
            				break;
            		case 164:
            				$questiona="Je souhaite souvent que les autres me comprennent mieux.";
            				$questionb="Mes amis disent qu'il est bon d'avoir auprès d'eux quelqu'un qui les comprend aussi bien que moi.";
            				$repA=4;
            				$repB=9;
            				break;
            		case 165:
            				$questiona="Je crois en la loyauté et à l'importance d'un engagement partagé avec d'autres pour une cause commune.";
            				$questionb="Pour moi la vie représente une grande variété d'expériences passionnantes.";
            				$repA=6;
            				$repB=7;
            				break;
            		case 166:
            				$questiona="J'ai besoin que les gens aient besoin de moi.";
            				$questionb="Je peux être agressif, toujours prêt à m'affirmer.";
            				$repA=2;
            				$repB=8;
            				break;
            		case 167:
            				$questiona="J'ai l'impression que je passe beaucoup de temps à rechercher l'approbation des autres.";
            				$questionb="Je veux être au dessus de toute critique ou condamnation venant de qui que ce soit.";
            				$repA=6;
            				$repB=1;
            				break;
            		case 168:
            				$questiona="J'ai tendance à me donner des objectifs précis et à évaluer clairement où j'en suis dans leur réalisation.";
            				$questionb="Mon style personnel est d'être quelqu'un de calme et d'imperturbable.";
            				$repA=3;
            				$repB=9;
            				break;
            		case 169:
            				$questiona="Pour moi la vie représente une multitude d'opportunités.";
            				$questionb="Je me considère comme une personne très directe.";
            				$repA=7;
            				$repB=8;
            				break;
            		case 170:
            				$questiona="Je suis souvent contrarié lorsque les autres empiètent sur mon temps.";
            				$questionb="Je pense que les gens me respectent car je suis fort et tenace dans les situations difficiles.";
            				$repA=5;
            				$repB=8;
            				break;
            		case 171:
            				$questiona="Je suis heureux quand j'essaie d'aider les autres.";
            				$questionb="J'essaie d'être très rassurant et calme dans mon interaction avec les autres.";
            				$repA=2;
            				$repB=9;
            				break;
            		case 172:
            				$questiona="Je suis heureux de montrer de la compassion pour les autres.";
            				$questionb="J'ai toujours un tas de rêves et de projets pour l'avenir.";
            				$repA=2;
            				$repB=7;
            				break;
            		case 173:
            				$questiona="Pour moi il est très important de donner l'image de quelqu'un qui réussit.";
            				$questionb="Habituellement je ne crains pas le rejet et ne me préoccupe pas du jugement des autres.";
            				$repA=3;
            				$repB=8;
            				break;
            		case 174:
            				$questiona="Je suis constamment en train de collecter et emmagasiner des connaissances.";
            				$questionb="Il est important pour moi de me sentir détendu quelle que soit la situation.";
            				$repA=5;
            				$repB=9;
            				break;
            		case 175:
            				$questiona="J'aime travailler dur pour remédier à une situation d'injustice";
            				$questionb="J'ai beaucoup de plaisir lorsqu'il est confirmé que j'ai raison";
            				$repA=8;
            				$repB=1;
            				break;
            		case 176:
            				$questiona="Je me considère comme une personne très sensible.";
            				$questionb="Je me considère optimiste et visionnaire face à mon avenir.";
            				$repA=4;
            				$repB=7;
            				break;
            		case 177:
            				$questiona="Je suis soucieux de prendre en considération les sentiments des autres.";
            				$questionb="Je peux bien prendre ma place dans un groupe grâce à ma loyauté et à mon sens des responsabilités envers lui.";
            				$repA=2;
            				$repB=6;
            				break;
            		case 178:
            				$questiona="Je préfère donner des ordres plutôt que de les recevoir.";
            				$questionb="J'ai besoin d'unité et d'harmonie dans ma vie.";
            				$repA=8;
            				$repB=9;
            				break;
            		case 179:
            				$questiona="J'ai tendance à m'isoler rapidement si je ne me sens pas partie prenante de ce qui se passe.";
            				$questionb="Il y a peu de choses en lesquelles je ne puisse trouver du plaisir.";
            				$repA=5;
            				$repB=7;
            				break;
            		case 180:
            				$questiona="Mon optimisme inné peut aider les autres à croire que \"tout va aller pour le mieux \".";
            				$questionb="Je n'aime pas voir les choses perturbées par les effets négatifs de conflits et de tensions.";
            				$repA=7;
            				$repB=9;
            				break;
            	}
	
                echo "<table border='1' width='80%' style=\"border-collapse: separate;border-radius: 10px;border-spacing: 0px;margin: 10px auto auto auto;\">";
                echo "<tr>
                <td rowspan='2' width='30' style=\"border-top:none;border-bottom:none;border-left-style:none;font-size: 12px;font-family: Verdana, Helvetica, Arial, sans-serif;\">A".$i."</td>
                <td style=\"font-size: 12px;font-family: Verdana, Helvetica, Arial, sans-serif;\">".$questiona."</td>
                <th width='20' style=\"border-top:none;border-right-style: none;font-size: 12px;font-family: Verdana, Helvetica, Arial, sans-serif;\"><input type='radio' name='A".$i."' value='".$repA."' style='color: orange;'></th>
                </tr>
                <tr>
                <td style=\"font-size: 12px;font-family: Verdana, Helvetica, Arial, sans-serif;\">".$questionb."</td>
                <td style=\"border-bottom:none;border-right-style: none;\"><input type='radio' name='A".$i."' value='".$repB."' style='color: orange;'></td></tr>\n";
                echo "</table> </br>";
            }
            ?>
            <input type="submit" value="Envoyer">
        </form>
    </div>
</body>
</html>