<?php
/*
Plugin Name: Form Handler
Description: Un plugin simple pour gérer un formulaire et envoyer des emails.
Version: 1.0
Author: Votre Nom
*/

function form_handler_shortcode() {
    ob_start();
    ?>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <input type="hidden" name="action" value="handle_form_submission">
        <label for="nom_prenom">Nom et Prénom:</label>
        <input type="text" id="nom_prenom" name="nom_prenom"><br><br>

        <?php
        for ($i = 1; $i <= 10; $i++) {
            switch ($i) {
                case 1:
                    $questiona = "Pour moi, il est très important de prendre soin des autres.";
                    $questionb = "Organiser les choses et les mener à terme me vient tout naturellement.";
                    $repA = 2;
                    $repB = 3;
                    break;
                case 2:
                    $questiona = "Pour moi, il est très important de bien me préparer avant de prendre une décision.";
                    $questionb = "Pour moi, la vie est faite d'une grande variété d'expériences passionnantes.";
                    $repA = 6;
                    $repB = 7;
                    break;
                case 3:
                    $questiona = "Je me considère comme un observateur avisé.";
                    $questionb = "J'ai toujours l'air de quelqu'un qui cherche constamment à s'améliorer.";
                    $repA = 5;
                    $repB = 1;
                    break;
                case 4:
                    $questiona = "Les autres me décrivent comme un \"réalisateur-compétiteur\".";
                    $questionb = "Mes amis disent de moi que je suis une personne qui prend part aux souffrances des autres.";
                    $repA = 3;
                    $repB = 4;
                    break;
                case 5:
                    $questiona = "J'essaie toujours d'être attentif aux besoins des autres.";
                    $questionb = "J'ai souvent tendance à dire autour de moi : \"Pourquoi s'agiter comme ça ? Pourquoi se faire du souci pour pas grand-chose ?\"";
                    $repA = 2;
                    $repB = 9;
                    break;
                case 6:
                    $questiona = "J'ai tendance à m'isoler rapidement si je ne me sens pas partie prenante de ce qui se passe.";
                    $questionb = "Dans un groupe, je suis habituellement celui qui voit la vie du bon côté.";
                    $repA = 5;
                    $repB = 7;
                    break;
                case 7:
                    $questiona = "A travers mon éducation, j'ai pris l'habitude de compter sur ceux qui représentent l'autorité pour décider de mes comportements.";
                    $questionb = "Face à la vie, je me considère comme un lutteur qui ne se laisse pas abattre.";
                    $repA = 6;
                    $repB = 8;
                    break;
                case 8:
                    $questiona = "Je souhaite souvent que les gens me comprennent mieux.";
                    $questionb = "Je me considère comme peu exigeant et facile à vivre.";
                    $repA = 4;
                    $repB = 9;
                    break;
                case 9:
                    $questiona = "Mon \"apparence\" est très importante pour moi.";
                    $questionb = "Je semble toujours prompt à réagir face aux périls de la vie.";
                    $repA = 3;
                    $repB = 6;
                    break;
                case 10:
                    $questiona = "Je me sens heureux lorsque j'essaie d'aider les autres.";
                    $questionb = "J'aimerais être plus dynamique dans la vie, mais pour cela j'ai souvent besoin d'être stimulé de l'extérieur.";
                    $repA = 2;
                    $repB = 9;
                    break;
            }

            echo "<table border='1' width='80%' style=\"border-collapse: separate;border-radius: 10px;border-spacing: 0px;margin: 10px auto auto auto;\">";
            echo "<tr>
            <td rowspan='2' width='30' style=\"border-top:none;border-bottom:none;border-left-style:none;font-size: 12px;font-family: Verdana, Helvetica, Arial, sans-serif;\">A".$i."</td>
            <td style=\"font-size: 12px;font-family: Verdana, Helvetica, Arial, sans-serif;\">".$questiona."</td>
            <th width='20' style=\"border-top:none;border-right-style: none;font-size: 12px;font-family: Verdana, Helvetica, Arial, sans-serif;\"><input type='radio' name='A".$i."' value='".$repA."' style='color: orange;'></th>
            </tr>
            <tr>
            <td style=\"font-size: 12px;font-family: Verdana, Helvetica, Arial, sans-serif;\">".$questionb."</td>
            <td style=\"border-bottom:none;border-right-style: none;\"><input type='radio' name='A".$i."' value='".$repB."' style='color: orange;'></td></tr>\n";
            echo "</table> </br>";
        }
        ?>

        <input type="submit" value="Envoyer">
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('form_handler', 'form_handler_shortcode');

function handle_form_submission() {
    // Initialisation des compteurs pour les réponses de 1 à 9
    $counts = array_fill(1, 9, 0);

    // Vérification que toutes les questions ont été répondues
    $allAnswered = true;
    for ($i = 1; $i <= 10; $i++) {
        if (!isset($_POST['A' . $i])) {
            $allAnswered = false;
            break;
        }
    }

    if ($allAnswered) {
        // Parcourir les réponses envoyées
        for ($i = 1; $i <= 10; $i++) {
            if (isset($_POST['A' . $i])) {
                $response = $_POST['A' . $i];
                if (isset($counts[$response])) {
                    $counts[$response]++;
                }
            }
        }

        // Construire le contenu de l'email
        $message = "Résultats du questionnaire :\n";
        for ($i = 1; $i <= 9; $i++) {
            $message .= "Réponse $i : {$counts[$i]} fois\n";
        }

        // Envoyer les résultats par email
        $to = 'destinataire@example.com';
        $subject = 'Résultats du questionnaire';
        $headers = array('Content-Type: text/plain; charset=UTF-8');
        
        if (wp_mail($to, $subject, $message, $headers)) {
            echo "<script>alert('Les résultats ont été envoyés avec succès.');</script>";
        } else {
            echo "<script>alert('L\'envoi des résultats a échoué.');</script>";
        }
    } else {
        echo "<script>alert('Veuillez répondre à toutes les questions.');</script>";
    }

    // Rediriger vers la page d'accueil après le traitement
    wp_redirect(home_url());
    exit();
}
add_action('admin_post_handle_form_submission', 'handle_form_submission');
add_action('admin_post_nopriv_handle_form_submission', 'handle_form_submission');
